import java.util.Date;
public class Transaction {
    private int transactionId; // Transaction number
    private int transactionType; // 1 -- deposit, 2 -- withdrawl
    private Date transactionDate;
    private double transactionAmount; // transaction amount
//Class variables
    private static int idForTransaction = 1;
// constants
    private final int DEPOSIT = 1;
    private final int WITHDRAW = 2;
// Constructors
    public Transaction(){
        this.transactionId = idForTransaction;
        this.transactionDate = new Date();
        idForTransaction++;
    }
    public Transaction(int type, double amount){
        this.transactionId = idForTransaction;
        this.transactionDate = new Date();
        this.transactionType = type;
        this.transactionAmount = amount;
        idForTransaction++;
    }
    public void setTransactionType(int transactionType) {
        this.transactionType = transactionType;
    }
    public double getTransactionAmount(){
        return this.transactionAmount;
    }
    @Override
    public String toString(){
        return ("Transaction Id:"+ this.transactionId +
        "\tTransaction Type:" + this.transactionType +
        "\tTransaction Amount:" + this.transactionAmount);
    }
} // End of Transaction class

    

