import java.util.ArrayList;
import java.util.Date;
/* PROG23863 Winter 2025
* Bank Accounts Application
* Class Account
* Date: March 24, 2025
* Author: Garima Verma
*/
public abstract class Account {
// Data members
// Instance variables
    private int accountNumber ;
    private String accountTitle;
    protected double balance;
    private final Date dateCreated;
    private int transactionType;
    private ArrayList<Transaction> transactions = new ArrayList<> ();

    // class variables
    private static double interestRate;
    protected static int numberOfAccounts = 0;
    protected static double sumOfBalances = 0.0;
    private static int accountId = 1;

    // Constant definitions
    private final int DEPOSIT = 1;
    private final int WITHDRAW = 2;

    // no-arg (or default) constructor
    public Account() {
        this.accountNumber = accountId;
        this.dateCreated = new Date();
        Account.accountId++;
        Account.numberOfAccounts++;
        Account.sumOfBalances += this.balance;
    }
// constructor with Arguments
    public Account(String newAccountTitle,double newBalance) {
        this.accountNumber = Account.accountId;
        this.accountTitle = newAccountTitle;
        this.balance = newBalance;
        this.dateCreated = new Date();
        Account.accountId++;
        Account.numberOfAccounts++;
        Account.sumOfBalances += this.balance;
    }
// Getters are created 
    public int getAccountNumber() {
        return this.accountNumber;
    }
    public double getBalance() {
        return this.balance;
    }
    public static double getInterestRate() {
        return Account.interestRate;
    }
    public double getMonthlyInterest() {
        return (this.balance * (Account.interestRate) / 1200);
    }
    public java.util.Date getDateCreated() {
        return this.dateCreated;
    }
    public void setBalance(double newBalance) {
        this.balance = newBalance;
        Account.sumOfBalances += newBalance;
    }
    public static void setInterestRate(double newInterestRate) {
        Account.interestRate = newInterestRate;
    }
// Manipulators
    public void withdraw(double amount) {
        this.balance -= amount;
        Account.sumOfBalances -= amount;
        this.transactions.add(new Transaction(WITHDRAW, amount));
    }
    public void deposit(double amount) {
        this. balance += amount;
        Account.sumOfBalances += amount;
        this.transactions.add(new Transaction(DEPOSIT, amount));
    }
// Class variable manipulation methods
    public static double averageBalance (){
        return (Account.sumOfBalances / Account.numberOfAccounts);
    }
// Get List of Transactions for an account
    public ArrayList<Transaction> getTransactions() {
        return this.transactions;
    }

 @Override   
    public String toString(){
        return ("Account Number: " + this.accountNumber +
        "\tAccount Balance: "+ this.balance);
    }
} // End of class Account